#include <stdio.h>
#include <string.h>
/* This program converts ASCII code tables provided at www.unicode.org
 * to binary Unicode tables usable for Volkov Commander and DOSLFN.
 * These ASCII code tables are at
 * http://www.unicode.org/Public/MAPPINGS/VENDORS/MICSFT/PC/
 *
 * To use this program, give the text file name, e.g.
 * mk_table cp737.txt
 * That will produce a file named "cp737uni.tbl".
 *
 * Compiled and linked with Borland C++ 3.1, but should work
 * with any compiler (however, target must have Intel byte order).
 * h#s 10/01
 */
int main(int argc,char**argv) {
 FILE *in,*out;
 int i;
 unsigned c;
 char line[256],cpname[64];
 if (argc<2) {
  fputs("You must provide an input file name!\n",stderr);
  return 3;
 }
 in=fopen(argv[1],"r");
 if (!in) {
  fprintf(stderr,"Cannot open input file %s!\n",argv[1]);
  return 3;
 }
 sscanf(argv[1],"%[^.]",line);
 strcat(line,"uni.tbl");
 out=fopen(line,"wb");
 if (!out) {
  fprintf(stderr,"Cannot create output file %s!\n",line);
  return 3;
 }

 while (1) {
  if (!fgets(line,sizeof(line),in)) {
   fputs("Missing header (must contain _DOSlanguage)!\n",stderr);
   return 1;
  }
  if (sscanf(line,"%*[^_]_DOS%s ",cpname)==1) break;
  /* for C learners, please look at that sscanf() template string,
   * and check out your documentation what "%*[^_]" does.
   * Therefore, a lesson about scanf should take two weeks(!!)
   * (including memory models), for printf another two weeks.
   */
 }
 fprintf(out,"Unicode (%s)\r\n\001",cpname);
 for (i=0x80; fgets(line,sizeof(line),in); ) {
  int j;
  if (line[0]=='#') continue;
  c=0xFFFF;		/* if there is an unused entry (e.g. Turkish) */
  if (sscanf(line,"%X %X",&j,&c)<1) continue;
  if (j==i) {
   fwrite(&c,2,1,out);
   i++;
  }
 }
 if (fclose(out) || fclose(in)) {
  fputs("Error closing files!\n",stderr);
  return 3;
 }
 if (i!=0x100) {
  fputs("Missing codes (not 128 above 127)!\n",stderr);
  return 2;
 }
 return 0;
}
