@rem Programs/Files needed : vcvar.exe vcdrive.bat
@echo off
rem Get version of VC
C:\SYSTEM\VC\vcvar.exe /q
if errorlevel 39 if not errorlevel 40 goto VC400
if errorlevel 42 if not errorlevel 43 goto VC402
rem Exit on any error
echo.
echo Error determining VC version !
goto ENDING


:VC400
rem Errorlevel 39 returned for VC 4.0 & 4.01 : active panel variable is Global 268
set a_p=268
goto GETACTIVE

:VC402
rem Errorlevel 42 returned for VC 4.02 & 4.03 : active panel variable is Global 267
set a_p=267

:GETACTIVE
rem Default source is Left panel
set source=L
rem Default destination is Right panel
set dest=R
rem Get active panel
C:\SYSTEM\VC\vcvar.exe /q /g /e %a_p%
rem If active panel is Right panel, switch default source & default destination
if errorlevel 1 set source=R
if %source%==R set dest=L
rem Get display status of destination panel
C:\SYSTEM\VC\vcvar.exe /q /%dest% /e 2
rem If destination panel not visible, proceed at NODEST
if not errorlevel 1 goto NODEST
rem Destination panel visible : get contents
C:\SYSTEM\VC\vcvar.exe /q /%dest% /e 0
rem If destination panel is a directory, proceed at GETDRIVE
if not errorlevel 1 goto GETDRIVE

:NODEST
rem Destination panel not visible or doesn't contain a directory : set destination equal to source
set dest=%source%

:GETDRIVE
rem Get drive-letter of source panel
C:\SYSTEM\VC\vcvar.exe /q /%source% /e 20
rem Call vcdrive.bat to convert an errorlevel to a corresponding drive specification in variable drive
call C:\SYSTEM\VC\vcdrive.bat 
rem If any error : exit
if not (%drive%)==() goto STOREDRIVE
echo.
echo Error determining Drive letter !
goto ENDING

:STOREDRIVE
rem Store source drive specification
set sdrive=%drive%
rem Get drive-letter of destination panel
C:\SYSTEM\VC\vcvar.exe /q /%dest% /e 20
rem Call vcdrive.bat again
call C:\SYSTEM\VC\vcdrive.bat 
rem Store destination drive specification
set ddrive=%drive%
echo.
echo Active panel is %source%.
echo A copy would be from %sdrive% to %ddrive%.


:ENDING
pause
